/*
 * @(#)CERSpecializationConnector.java  1.0  21. M�rz 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.diagram;

import java.awt.*;
import java.awt.geom.*;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.connector.AbstractConnector;
/**
 * CERSpecializationConnector.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 21. M�rz 2006 Created.
 */
public class CERSpecializationConnector extends AbstractConnector {
    
    /** Creates a new instance. */
    public CERSpecializationConnector() {
    }
    public CERSpecializationConnector(CERISAFigure owner) {
        super(owner);
    }
    
    /**
     * Tests if a point is contained in the connector.
     */
    @Override
    public boolean contains(Point2D.Double p) {
        Rectangle2D.Double r = getBounds();
        return getOwner().contains(p) && p.y < r.y + r.height / 2;
    }
    @Override
    public Rectangle2D.Double getBounds() {
        return ((DecoratedFigure) getOwner()).getDecorator().getBounds();
    }
    @Override
    public Point2D.Double getAnchor() {
        Rectangle2D.Double r = getBounds();
        double w = AttributeKeys.getStrokeTotalWidth(((DecoratedFigure) getOwner()).getDecorator());
        return new Point2D.Double(r.x + r.width / 2, r.y - w);
    }
   @Override protected Point2D.Double findPoint(ConnectionFigure connection) {
        return getAnchor();
        /*
        Rectangle2D.Double r = getBounds();
        return new Point2D.Double(r.x + r.width / 2, r.y + r.height / 2);
         */
    }
    @Override
    public void draw(Graphics2D g) {
        //Rectangle2D.Double bounds = getBounds();
        Point2D.Double p = getAnchor();
        Ellipse2D.Double circle = new Ellipse2D.Double(p.x - 3, p.y - 3, 6, 6);
        g.setColor(Color.blue);
        g.fill(circle);
    }
}
